/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block.blockentity;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import untamedwilds.config.ConfigMobControl;
import untamedwilds.entity.ComplexMob;
import untamedwilds.init.ModBlock;
import untamedwilds.util.EntityUtils;

public class CritterBurrowBlockEntity
extends BlockEntity {
    private final List<Inhabitants> inhabitants = Lists.newArrayList();
    private EntityType<?> entityType;
    private int variant;
    private int count;

    public CritterBurrowBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlock.TILE_ENTITY_BURROW.get(), pos, state);
    }

    public int getSumMobs() {
        return this.inhabitants.size() + this.count;
    }

    public boolean hasNoMobs() {
        return this.getSumMobs() == 0;
    }

    public void tryEnterBurrow(LivingEntity entityIn) {
        entityIn.m_8127_();
        entityIn.m_20153_();
        CompoundTag CompoundTag2 = EntityUtils.writeEntityToNBT(entityIn, true);
        this.inhabitants.add(new Inhabitants(CompoundTag2));
        if (this.f_58857_ != null) {
            BlockPos blockpos = this.m_58899_();
            this.f_58857_.m_6263_(null, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), SoundEvents.f_11695_, SoundSource.BLOCKS, 1.0f, 1.0f);
            EntityUtils.spawnParticlesOnEntity(this.f_58857_, entityIn, ParticleTypes.f_123759_, 3, 6);
        }
        entityIn.m_142687_(Entity.RemovalReason.DISCARDED);
        this.m_6596_();
    }

    public void releaseOrCreateMob(ServerLevel worldIn) {
        BlockPos blockpos;
        if (!this.hasNoMobs() && this.getEntityType() != null && (double)worldIn.m_5822_().nextFloat() < 0.1 * (double)(this.getSumMobs() * this.getSumMobs()) && worldIn.m_45914_((double)(blockpos = this.m_58899_()).m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, (double)((Integer)ConfigMobControl.critterSpawnRange.get()).intValue())) {
            Entity spawn;
            if (!this.getInhabitants().isEmpty()) {
                int i = worldIn.f_46441_.nextInt(this.inhabitants.size());
                Entity spawn2 = this.getEntityType().m_20655_(worldIn, this.inhabitants.get((int)i).entityData, null, null, blockpos, MobSpawnType.DISPENSER, true, false);
                if (spawn2 != null) {
                    worldIn.m_47205_(spawn2);
                    this.inhabitants.remove(i);
                    this.m_6596_();
                }
            } else if (this.getCount() > 0 && this.getEntityType() != null && (spawn = this.getEntityType().m_20615_((Level)worldIn)) != null) {
                spawn.m_7678_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, Mth.m_14177_((float)(worldIn.f_46441_.nextFloat() * 360.0f)), 0.0f);
                if (spawn instanceof Mob) {
                    Mob mobSpawn = (Mob)spawn;
                    mobSpawn.m_6518_((ServerLevelAccessor)worldIn, worldIn.m_6436_(blockpos), MobSpawnType.CHUNK_GENERATION, null, null);
                }
                if (spawn instanceof ComplexMob) {
                    ComplexMob entitySpawn = (ComplexMob)spawn;
                    entitySpawn.setVariant(EntityUtils.getClampedNumberOfSpecies(this.variant, this.entityType));
                    entitySpawn.setHome(this.m_58899_());
                }
                worldIn.m_47205_(spawn);
                this.setCount(this.getCount() - 1);
                this.m_6596_();
            }
            if (worldIn.m_5822_().nextInt((Integer)ConfigMobControl.burrowRepopulationChance.get()) == 0 && this.getCount() < 20) {
                this.setCount(this.getCount() + 1);
            }
        }
    }

    public void setCount(int newCount) {
        this.count = newCount;
    }

    public int getCount() {
        return this.count;
    }

    public void setVariant(int variant) {
        this.variant = variant;
    }

    public int getVariant() {
        return this.variant;
    }

    public void setEntityType(EntityType<?> type) {
        this.entityType = type;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.inhabitants.clear();
        ListTag listnbt = compound.m_128437_("Inhabitants", 10);
        this.setVariant(compound.m_128451_("Variant"));
        this.setCount(compound.m_128451_("Count"));
        if (compound.m_128441_("entityType")) {
            this.setEntityType(EntityType.m_20632_((String)compound.m_128461_("entityType")).orElse(null));
        }
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag CompoundTag2 = listnbt.m_128728_(i);
            Inhabitants beehivetileentity$bee = new Inhabitants(CompoundTag2.m_128469_("EntityData"));
            this.inhabitants.add(beehivetileentity$bee);
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("Inhabitants", (Tag)this.getInhabitants());
        compound.m_128405_("Count", this.getCount());
        compound.m_128405_("Variant", this.getVariant());
        if (this.getEntityType() != null) {
            compound.m_128359_("entityType", this.getEntityType().getRegistryName().toString());
        }
    }

    public ListTag getInhabitants() {
        ListTag inhabitants = new ListTag();
        for (Inhabitants inhabitant : this.inhabitants) {
            CompoundTag CompoundTag2 = new CompoundTag();
            CompoundTag2.m_128365_("EntityData", (Tag)inhabitant.entityData);
            inhabitants.add((Object)CompoundTag2);
        }
        return inhabitants;
    }

    static class Inhabitants {
        private final CompoundTag entityData;

        private Inhabitants(CompoundTag nbt) {
            nbt.m_128473_("UUID");
            this.entityData = nbt;
        }
    }
}

